<?php
App::uses('AppModel', 'Model');
/**
 * Category Model
 *
 * @property Category $Category
 */
class Category extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'title';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'title' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		)
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	
	public $hasAndBelongsToMany = array(
        
		'Department' =>
            array(
                'className' => 'Department',
                'joinTable' => 'category_departments',
                'foreignKey' => 'department_id',
                'associationForeignKey' => 'category_id',
                'dependent' => false,
				'conditions' => '',
				'fields' => '',
				'order' => '',
				'limit' => '',
				'offset' => '',
				'exclusive' => '',
				'finderQuery' => '',
				'counterQuery' => ''
            )
    );
	
}