<?php
App::uses('AppController', 'Controller');
/**
 * Results Controller
 *
 * @property Result $Result
 * @property PaginatorComponent $Paginator
 */
class ResultsController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index($studentinformtion_id = null) {
		$this->Result->recursive = 0;
		$this->set('results', $this->Result->find('all',array('conditions'=>array('Result.studentinformtion_id'=>$studentinformtion_id))));
	}

/**
 * admin_add method
 *
 * @return void
 */
	public function admin_add() {
		if ($this->request->is('post')) {
			$this->Result->create();
			if ($this->Result->save($this->request->data)) {
				$this->Session->setFlash(__('The Result has been saved.'), 'default', array('class' => 'alert alert-success'));
				return $this->redirect(array('controller'=>'results','action' => 'index',$this->request->data['Result']['studentinformtion_id']));
			} else {
				$this->Session->setFlash(__('The Result could not be saved. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
				return $this->redirect(array('action' => 'add',$this->request->data['Result']['studentinformtion_id']));
			}
		}
	}

/**
 * admin_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		if (!$this->Result->exists($id)) {
			throw new NotFoundException(__('Invalid Result'));
		}
		if ($this->request->is(array('post', 'put'))) {
			if ($this->Result->save($this->request->data)) {
				$this->Session->setFlash(__('The Result has been saved.'), 'default', array('class' => 'alert alert-success'));
				return $this->redirect(array('action' => 'index',$this->request->data['Result']['studentinformtion_id']));
			} else {
				$this->Session->setFlash(__('The Result could not be saved. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
			}
		} else {
			$options = array('conditions' => array('Result.' . $this->Result->primaryKey => $id));
			$this->request->data = $this->Result->find('first', $options);
		}
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null, $studentinformtion_id = null) {
		$this->Result->id = $id;
		if (!$this->Result->exists()) {
			throw new NotFoundException(__('Invalid Result'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->Result->delete()) {
			$this->Session->setFlash(__('The Result has been deleted.'), 'default', array('class' => 'alert alert-success'));
		} else {
			$this->Session->setFlash(__('The Result could not be deleted. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
		}
		return $this->redirect(array('action' => 'index',$studentinformtion_id));
	}}
