<?php
class NoticesController extends AppController {
	
	var $name = 'Notices';
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('download');
	}

	function index() {
		$this->layout = 'inner';
		$this->Notice->recursive = 0;									
		$this->paginate = array('conditions' => array('Notice.isactive' => 1),'order' => array('Notice.order'=>'ASC'),'limit'=>10);	
		$this->set('newses', $this->Paginator->paginate());
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid Notice', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('news', $this->Notice->read(null, $id));
	}
	
	public function download($id = null) {
	
		$this->layout='ajax';
		if(!empty($id)){
		$file_id = $id;
		$downloadfile = $this->Notice->read(null, $file_id);   
		$path = Configure::read("files"."/"."news/");           
		$fileName = $downloadfile['Notice']['attach_file'];
		//debug($path); exit;
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename($fileName));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($path.$fileName));
		//ob_clean();
		flush();
		readfile($path.$fileName);
		exit;
		}
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->Notice->recursive = 0;
		$this->paginate = array('order'=>'Notice.created DESC');
		$this->set('newses', $this->Paginator->paginate());
	}
    
    function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Notice' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Notice->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }

	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Notice']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."news";
					$target_path_for_database ="files"."/"."news/";
					$filename = $this->request->data['Notice']['attachfile']['name'];
					$tmpname  = $this->request->data['Notice']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Notice']['attachfile']['size'];
					$filetype = $this->request->data['Notice']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,doc,docx,pdf,txt');				
					if(strlen($filename1) > 0){
						$this->request->data['Notice']['attach_file'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			
			/*Date condersion here*/
			$this->request->data['Notice']['posted_date'] = strtotime(str_replace('/', '-', $this->request->data['Notice']['posted_date']));
				
			$this->Notice->create();
			if ($this->Notice->save($this->request->data)) {
				$this->Session->setFlash(__('The Notice has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Notice could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid Notice', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Notice']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."news";
				$target_path_for_database ="files"."/"."news/";
				$filename = $this->request->data['Notice']['attachfile']['name'];
				$tmpname  = $this->request->data['Notice']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Notice']['attachfile']['size'];
				$filetype = $this->request->data['Notice']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif,doc,docx,pdf,txt');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['Notice']['attach_file'])){
						if(unlink($this->request->data['Notice']['attach_file'])){
							$this->request->data['Notice']['attach_file'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Notice']['attach_file'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}
			/*Date condersion here*/
			$this->request->data['Notice']['posted_date'] = strtotime(str_replace('/', '-', $this->request->data['Notice']['posted_date']));
			if ($this->Notice->save($this->request->data)) {
				$this->Session->setFlash(__('The Notice has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Notice could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Notice']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Notice->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Notice', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Notice->find('first',array('conditions'=>array('Notice.id'=>$id),'fields'=>array('Notice.attach_file')));
		if(!empty($filename['Notice']['attach_file'])){
			if(unlink($filename['Notice']['attach_file'])){
				if ($this->Notice->delete($id)) {
					$this->Session->setFlash(__('Notice deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Notice->delete($id)) {
					$this->Session->setFlash(__('Notice deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->Notice->delete($id)) {
					$this->Session->setFlash(__('Notice deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
		}
		$this->Session->setFlash(__('Notice was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>