<?php
class NewsController extends AppController {
	var $name = 'News';
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('view');
	}

	function index() {
		$this->layout = 'inner';
		$this->News->recursive = 0;									
		$this->paginate = array('conditions' => array('News.isactive' => 1),'order' => array('News.order'=>'ASC'),'limit'=>20);	
		$this->set('newses', $this->Paginator->paginate($this->News));
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid news', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('news', $this->News->read(null, $id));
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->News->recursive = 0;
		$this->paginate = array('order'=>'News.created DESC');
		$this->set('newses', $this->Paginator->paginate());
	}
    
    function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('News' => array( 'id'=> $id,'order'=>$order));   
           
        $this->News->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }

	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['News']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."news";
					$target_path_for_database ="files"."/"."news/";
					$filename = $this->request->data['News']['attachfile']['name'];
					$tmpname  = $this->request->data['News']['attachfile']['tmp_name'];
					$filesize = $this->request->data['News']['attachfile']['size'];
					$filetype = $this->request->data['News']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,doc,docx,pdf,txt');				
					if(strlen($filename1) > 0){
						$this->request->data['News']['attach_file'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			
			/*Date condersion here*/
			$this->request->data['News']['posted_date'] = strtotime(str_replace('/', '-', $this->request->data['News']['posted_date']));
				
			$this->News->create();
			if ($this->News->save($this->request->data)) {
				$this->Session->setFlash(__('The news has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The news could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid news', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['News']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."news";
				$target_path_for_database ="files"."/"."news/";
				$filename = $this->request->data['News']['attachfile']['name'];
				$tmpname  = $this->request->data['News']['attachfile']['tmp_name'];
				$filesize = $this->request->data['News']['attachfile']['size'];
				$filetype = $this->request->data['News']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif,doc,docx,pdf,txt');					
				if(strlen($filename1) > 0){
					
					//if(!empty($this->request->data['News']['attach_file'])){
						//if(unlink($this->request->data['News']['attach_file'])){
							$this->request->data['News']['attach_file'] = $target_path_for_database.$filename1;						
						//}
					//}
					
				}
				
			}
			/*Date condersion here*/
			$this->request->data['News']['posted_date'] = strtotime(str_replace('/', '-', $this->request->data['News']['posted_date']));
			if ($this->News->save($this->request->data)) {
				$this->Session->setFlash(__('The news has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The news could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['News']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->News->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for news', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->News->find('first',array('conditions'=>array('News.id'=>$id),'fields'=>array('News.attach_file')));
		if(!empty($filename['News']['attach_file'])){
			if(unlink($filename['News']['attach_file'])){
				if ($this->News->delete($id)) {
					$this->Session->setFlash(__('News deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->News->delete($id)) {
						$this->Session->setFlash(__('News deleted.', true));
						$this->redirect(array('action'=>'index'));
					}	
			}
		}else{
			if ($this->News->delete($id)) {
					$this->Session->setFlash(__('News deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
		}
		$this->Session->setFlash(__('News was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>