<?php
class MessagesController extends AppController {
	
	var $name = 'Messages';
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		//$this->Auth->allow();
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid Message', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('message', $this->Message->read(null, $id));
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->Message->recursive = 0;
		$this->paginate = array('order'=>'Message.created DESC');
		$this->set('messages', $this->Paginator->paginate());
	}
    
    function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Message' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Message->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }

	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Message']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."news";
					$target_path_for_database ="files"."/"."news/";
					$filename = $this->request->data['Message']['attachfile']['name'];
					$tmpname  = $this->request->data['Message']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Message']['attachfile']['size'];
					$filetype = $this->request->data['Message']['attachfile']['type'];							
					$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif');				
					if(strlen($filename) > 0){
						$this->request->data['Message']['attach_file'] = $target_path_for_database.$filename;						
					}					
					
				}//End
			
			$this->Message->create();
			if ($this->Message->save($this->request->data)) {
				$this->Session->setFlash(__('The Message has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Message could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid Message', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Message']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."news";
				$target_path_for_database ="files"."/"."news/";
				$filename = $this->request->data['Message']['attachfile']['name'];
				$tmpname  = $this->request->data['Message']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Message']['attachfile']['size'];
				$filetype = $this->request->data['Message']['attachfile']['type'];							
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif');					
				if(strlen($filename) > 0){
					
					if(!empty($this->request->data['Message']['attach_file'])){
						if(unlink($this->request->data['Message']['attach_file'])){
							$this->request->data['Message']['attach_file'] = $target_path_for_database.$filename;						
						}
					}else{
						$this->request->data['Message']['attach_file'] = $target_path_for_database.$filename;						
					}
					
				}
				
			}
			if ($this->Message->save($this->request->data)) {
				$this->Session->setFlash(__('The Message has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Message could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Message']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Message->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Message', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Message->find('first',array('conditions'=>array('Message.id'=>$id),'fields'=>array('Message.attach_file')));
		if(!empty($filename['Message']['attach_file'])){
			if(unlink($filename['Message']['attach_file'])){
				if ($this->Message->delete($id)) {
					$this->Session->setFlash(__('Message deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Message->delete($id)) {
						$this->Session->setFlash(__('Message deleted.', true));
						$this->redirect(array('action'=>'index'));
					}	
			}
		}else{
			if ($this->Message->delete($id)) {
					$this->Session->setFlash(__('Message deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
		}
		$this->Session->setFlash(__('Message was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>