<?php
class ManagementsController extends AppController {
	var $name = 'Managements';
	
	public $components = array('Paginator','FileUpload');
	
	
	function beforeFilter(){
		parent::beforeFilter();
		//$this->Auth->allow('view');
	}

	function index($comtype = null) {
		
		$this->layout = 'inner';
		$this->Management->recursive = 0;									
		$this->paginate = array('conditions' => array('Management.comtype' => $comtype,'Management.isactive' => 1),'limit'=>20,'order'=>array('Management.order'=>'ASC'));	
		$this->set('managements', $this->Paginator->paginate($this->Management));

	}

	function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Management' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Management->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }
	
	function admin_index() {
		$this->layout = 'default';
		$this->Management->recursive = 0;
		$this->paginate = array('order'=>'Management.created DESC');
		$this->set('managements', $this->Paginator->paginate());
	}
   
	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Management']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."photo";
					$target_path_for_database ="files"."/"."photo/";
					$filename = $this->request->data['Management']['attachfile']['name'];
					$tmpname  = $this->request->data['Management']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Management']['attachfile']['size'];
					$filetype = $this->request->data['Management']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif');				
					if(strlen($filename1) > 0){
						$this->request->data['Management']['image'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			$this->Management->create();
			if ($this->Management->save($this->request->data)) {
				$this->Session->setFlash(__('The management infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The management infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid infromation!', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Management']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				$filename = $this->request->data['Management']['attachfile']['name'];
				$tmpname  = $this->request->data['Management']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Management']['attachfile']['size'];
				$filetype = $this->request->data['Management']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['Management']['image'])){
						if(unlink($this->request->data['Management']['image'])){
							$this->request->data['Management']['image'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Management']['image'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}
			if ($this->Management->save($this->request->data)) {
				$this->Session->setFlash(__('The management infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The management infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Management']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Management->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Management infromation!', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Management->find('first',array('conditions'=>array('Management.id'=>$id),'fields'=>array('Management.image')));
		if(!empty($filename['Management']['image'])){
			if(unlink($filename['Management']['image'])){
				if ($this->Management->delete($id)) {
					$this->Session->setFlash(__('Management infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Management->delete($id)) {
					$this->Session->setFlash(__('Management infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->Management->delete($id)) {
				$this->Session->setFlash(__('Management infromation deleted.', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		$this->Session->setFlash(__('Management infromation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>