<?php
class LibrariesController extends AppController {
	var $name = 'Libraries';
	
	public $uses = array('Library','Department');
	public $components = array('Paginator','FileUpload');
	
	
	function beforeFilter(){
		parent::beforeFilter();
		//$this->Auth->allow('view');
	}

	function index($deptid = null) {
		
		$this->layout = 'inner';
		$this->Library->recursive = 0;									
		$this->paginate = array('conditions' => array('Library.department_id' => $deptid,'Library.isactive' => 1),'limit'=>20,'order'=>array('Library.order'=>'ASC'));	
		$this->set('books', $this->Paginator->paginate($this->Library));

	}

	
	function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Library' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Library->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }
	
	function admin_index() {
		$this->layout = 'default';
		$this->Library->recursive = 0;
		$this->paginate = array('order'=>'Library.created DESC');
		$this->set('books', $this->Paginator->paginate());
	}
   
	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			
			if($this->request->data['Library']['attachment']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."course";
				$target_path_for_database ="files"."/"."course/";
				
				$filename = $this->request->data['Library']['attachment']['name'];
				$tmpname  = $this->request->data['Library']['attachment']['tmp_name'];
				$filesize = $this->request->data['Library']['attachment']['size'];
				$filetype = $this->request->data['Library']['attachment']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp,pdf,doc,docx,xls,xlsx');
				
				if(strlen($filename) > 0){
					$this->request->data['Library']['booklist'] = $target_path_for_database.$filename;
				}else{
					$this->Session->setFlash("The file type is not valid.",true);
					$this->redirect(array('controller' => 'libraries','action'=>'add'));
				}				
			}
			
			$this->Library->create();
			if ($this->Library->save($this->request->data)) {
				$this->Session->setFlash(__('The book infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The book infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
		
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
		
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid infromation!', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
			
			if($this->request->data['Library']['attachment']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."course";
				$target_path_for_database ="files"."/"."course/";
				
				$filename = $this->request->data['Library']['attachment']['name'];
				$tmpname  = $this->request->data['Library']['attachment']['tmp_name'];
				$filesize = $this->request->data['Library']['attachment']['size'];
				$filetype = $this->request->data['Library']['attachment']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp,pdf,doc,docx,xls,xlsx');
				
				if(strlen($filename) > 0){
					if(!empty($this->request->data['Library']['booklist'])){
						if(unlink($this->request->data['Library']['booklist'])){
							$this->request->data['Library']['booklist'] = $target_path_for_database.$filename;
						}
					}else{
						$this->request->data['Library']['booklist'] = $target_path_for_database.$filename;
					}
				}
								
			}
			
			if ($this->Library->save($this->request->data)) {
				$this->Session->setFlash(__('The book infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The book infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Library']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Library->read(null, $id);
		}
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
	}

	function admin_delete($id = null) {
		
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for book infromation!', true));
			$this->redirect(array('action'=>'index'));
		}
		
		if ($this->Library->delete($id)) {
			$this->Session->setFlash(__('Book infromation deleted.', true));
			$this->redirect(array('action'=>'index'));
		}
		$this->Session->setFlash(__('Book infromation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>