<?php
class HomesController extends AppController {
	
	public $uses = array('News','Content','Banner','Notice','Category','Subscriber','Career','PhotoCategory','Department','Message','CoCurricularActivity');

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator');

	public function beforeFilter(){	  
	   parent::beforeFilter();
	   $this->Auth->allow('addsubscriberemail','getNotice','getCourse','getDepartment','getMessage','getCoCurricularActivity');
	}
	
	public function addsubscriberemail($email)
    {
       $this->autoRender = false;
	   $isunique = $this->Subscriber->find('first', array('conditions'=>array('Subscriber.semail' => $email,'Subscriber.isactive' => 1)));
	   if(empty($isunique)){
		   $data = array('Subscriber' => array( 'semail'=> $email,'isactive'=>1));   
		   $this->Subscriber->save($data);
		   echo "OK";
	   }else{
	   	   echo "ERROR";
	   }
    }	
	
	public function index(){
		
		$this->layout = 'home';
		$this->set("title_for_layout","Homes");
		
		$date = strtotime(date('d-m-Y'));
				
		$banners = $this->Banner->find('all', array('conditions'=>array('Banner.isactive' => 1),'limit'=>'8','order' => array('Banner.id' => 'ASC')));
		$this->set('banners',$banners);
		
		$notices = $this->Notice->find('all', array('conditions'=>array('Notice.isactive' => 1),'limit'=>'5','order' => array('Notice.order' => 'ASC','Notice.created' => 'DESC')));
		$this->set('notices',$notices);
		
		$newses = $this->News->find('all', array('conditions'=>array('News.isactive' => 1),'limit'=>'5','order' => array('News.order' => 'ASC','News.created' => 'DESC')));
		$this->set('newses',$newses);
		
		 $messages = $this->Message->find('all', array('conditions'=>array('Message.isactive' => 1),'order' => array('Message.order' => 'ASC')));
		$this->set('messages',$messages);
		
		$content = $this->Content->find('first', array('conditions'=>array('Content.pagealias' => 'about-us')));
		$this->set('content',$content);
		
		$photocategories = $this->PhotoCategory->find('all',array('conditions'=>array('PhotoCategory.isactive'=>1),'limit'=>'10','order' => array('PhotoCategory.created' => 'DESC')));
		$this->set('photocategories',$photocategories);
				
	}
	
	 public function getNotice() {
		 
        $notices = $this->Notice->find('all', array('conditions'=>array('Notice.isactive' => 1),'limit'=>'5','order' => array('Notice.order' => 'ASC','Notice.created' => 'DESC')));
		
		if (!empty($this->request->params['requested'])) {
            return $notices;
        }
		
    }
	
	public function getCoCurricularActivity() {
		 
        $activities = $this->CoCurricularActivity->find('all', array('conditions'=>array('CoCurricularActivity.isactive' => 1),'order' => array('CoCurricularActivity.order' => 'ASC','CoCurricularActivity.created' => 'DESC')));
		
		if (!empty($this->request->params['requested'])) {
            return $activities;
        }
		
    }
	
	 public function getCourse() {
		 
        $courses = $this->Category->find('all', array('conditions'=>array('Category.isactive' => 1),'order' => array('Category.id' => 'ASC')));
		
		if (!empty($this->request->params['requested'])) {
            return $courses;
        }
		
    }
	
	public function getDepartment() {
		 
        $this->Department->recursive = -1;									
		$departments = $this->Department->find('all', array('conditions'=>array('Department.isactive' => 1),'fields' => array('Department.id','Department.title'),'order' => array('Department.id' => 'ASC')));
		
		if (!empty($this->request->params['requested'])) {
            return $departments;
        }
		
    }
	
	public function getMessage() {
		 
        $messages = $this->Message->find('all', array('conditions'=>array('Message.isactive' => 1),'fields' => array('Message.id','Message.title'),'order' => array('Message.order' => 'ASC')));
		
		if (!empty($this->request->params['requested'])) {
            return $messages;
        }
		
    }
	
	public function admin_index(){
		
		$this->layout = 'default';
		$this->set("title_for_layout","Admin Dashboard");
		
	}
}

?>