<?php
class EmployesController extends AppController {
	var $name = 'Employes';
	
	public $components = array('Paginator','FileUpload');
	
	
	function beforeFilter(){
		parent::beforeFilter();
		//$this->Auth->allow('view');
	}

	function index() {
		
		$this->layout = 'inner';
		$this->Employe->recursive = 0;									
		$this->paginate = array('conditions' => array('Employe.isactive' => 1),'limit'=>20,'order'=>array('Employe.order'=>'ASC'));	
		$this->set('employees', $this->Paginator->paginate($this->Employe));

	}

	function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Employe' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Employe->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }
	
	function admin_index() {
		$this->layout = 'default';
		$this->Employe->recursive = 0;
		$this->paginate = array('order'=>'Employe.created DESC');
		$this->set('employees', $this->Paginator->paginate());
	}
   
	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['Employe']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."photo";
					$target_path_for_database ="files"."/"."photo/";
					$filename = $this->request->data['Employe']['attachfile']['name'];
					$tmpname  = $this->request->data['Employe']['attachfile']['tmp_name'];
					$filesize = $this->request->data['Employe']['attachfile']['size'];
					$filetype = $this->request->data['Employe']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif');				
					if(strlen($filename1) > 0){
						$this->request->data['Employe']['image'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			$this->Employe->create();
			if ($this->Employe->save($this->request->data)) {
				$this->Session->setFlash(__('The employe infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The employe infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid infromation!', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Employe']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				$filename = $this->request->data['Employe']['attachfile']['name'];
				$tmpname  = $this->request->data['Employe']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Employe']['attachfile']['size'];
				$filetype = $this->request->data['Employe']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['Employe']['image'])){
						if(unlink($this->request->data['Employe']['image'])){
							$this->request->data['Employe']['image'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Employe']['image'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}
			if ($this->Employe->save($this->request->data)) {
				$this->Session->setFlash(__('The employe infromation has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The employe infromation could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Employe']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Employe->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Employe infromation!', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Employe->find('first',array('conditions'=>array('Employe.id'=>$id),'fields'=>array('Employe.image')));
		if(!empty($filename['Employe']['image'])){
			if(unlink($filename['Employe']['image'])){
				if ($this->Employe->delete($id)) {
					$this->Session->setFlash(__('Employe infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Employe->delete($id)) {
					$this->Session->setFlash(__('Employe infromation deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}
		}else{
			if ($this->Employe->delete($id)) {
				$this->Session->setFlash(__('Employe infromation deleted.', true));
				$this->redirect(array('action'=>'index'));
			}
		}
		$this->Session->setFlash(__('Employe infromation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>