<?php
App::uses('AppController', 'Controller');
/**
 * Downloads Controller
 *
 * @property Download $Download
 * @property FileUploadComponent $FileUpload
 */
class DownloadsController extends AppController {
	
/**
 * Components
 *
 * @var array
 */
	public $components = array('FileUpload');
	
	public function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('download','admin_resultadd','admin_resultindex','admin_totlistadd','admin_totlistindex');
	}

/**
 * index method
 *
 * @return void
 */
	public function index($content_type = null) {
		$this->layout = 'inner';
		$this->set('downloads', $this->Download->find('all',array('conditions'=>array('Download.content_type'=>$content_type),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'))));
	}
	
	public function download($id = null) {
	
		$this->layout='ajax';
		if(!empty($id)){
		$file_id = $id;
		$downloadfile = $this->Download->read(null, $file_id);   
		$path = Configure::read("files"."/"."downloadfile/");           
		$fileName = $downloadfile['Download']['downloadfile'];
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename($fileName));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($path.$fileName));
		//ob_clean();
		flush();
		readfile($path.$fileName);
		exit;
		}
	}

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>1),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}

/**
 * admin_add method
 *
 * @return void
 */
	public function admin_add() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'index'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'add'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'add'));
			}
		}
	}
	
	
/**
 * admin_lecindex method
 *
 * @return void
 */
	public function admin_lecindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>3),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_lecadd method
 *
 * @return void
 */
	public function admin_lecadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'lecindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'lecadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'lecadd'));
			}
		}
	}
	
/**
 * admin_attindex method
 *
 * @return void
 */
	public function admin_attindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>2),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_attadd method
 *
 * @return void
 */
	public function admin_attadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'attindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'attadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'attadd'));
			}
		}
	}
	
	
/**
 * admin_formindex method
 *
 * @return void
 */
	public function admin_formindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>4),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_formadd method
 *
 * @return void
 */
	public function admin_formadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'formindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'formadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'formadd'));
			}
		}
	}
	
/**
 * admin_acacindex method
 *
 * @return void
 */
	public function admin_acacindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>5),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_acacadd method
 *
 * @return void
 */
	public function admin_acacadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'acacindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'acacadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'acacadd'));
			}
		}
	}
	
/**
 * admin_resultindex method
 *
 * @return void
 */
	public function admin_resultindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>6),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_acacadd method
 *
 * @return void
 */
	public function admin_resultadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'resultindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'resultadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'resultadd'));
			}
		}
	}
	
/**
 * admin_totlistindex method
 *
 * @return void
 */
	public function admin_totlistindex() {
		$this->Download->recursive = 0;
		$this->paginate = array('conditions'=>array('Download.content_type'=>7),'order'=>array('Download.order'=> 'ASC','Download.created'=> 'DESC'));
		$this->set('downloads', $this->paginate($this->Download));
	}
	
	
/**
 * admin_totlistadd method
 *
 * @return void
 */
	public function admin_totlistadd() {
		
		if ($this->request->is('post')) {
			
			if($this->request->data['Download']['dfile']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."downloadfile";
				$target_path_for_database ="files"."/"."downloadfile/";
				
				$filename = $this->request->data['Download']['dfile']['name'];
				$tmpname  = $this->request->data['Download']['dfile']['tmp_name'];
				$filesize = $this->request->data['Download']['dfile']['size'];
				$filetype = $this->request->data['Download']['dfile']['type'];
				$newfilename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif,pdf,doc,docx');
				
				if(strlen($newfilename) > 0){
					$this->request->data['Download']['downloadfile'] = $target_path_for_database.$newfilename;
				}			
			}
			
			$this->Download->create();
			if(!empty($this->request->data['Download']['dfile'])){
				if ($this->Download->save($this->request->data)) {
					$this->Session->setFlash(__('The file has been saved'));
					$this->redirect(array('action' => 'totlistindex'));
				} else {
					$this->Session->setFlash(__('The file could not be saved. Please, try again.'));
					$this->redirect(array('action' => 'totlistadd'));
				}
			}else {
					$this->Session->setFlash(__('File type/size is not valid.'));
					$this->redirect(array('action' => 'totlistadd'));
			}
		}
	}
	
	public function admin_updateneworder($id,$order) {
		$this->layout = "ajax";
		$data = array('Download' => array( 'id'=> $id,'order'=>$order));   
		$this->Download->save($data);
		$this->set('rowid', $id );
        $this->set('orderofrow', $order );       
    }

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid file'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'index'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'index'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'index'));
		
	}
	
/**
 * admin_lecdelete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param string $id
 * @return void
 */
	public function admin_lecdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'lecindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'lecindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'lecindex'));
		
	}
	
	public function admin_attdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'attindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'attindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'attindex'));
		
	}
	
	public function admin_formdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'formindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'formindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'formindex'));
		
	}
	
	public function admin_acacdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'acacindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'acacindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'acacindex'));
		
	}
	
	public function admin_resultdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'resultindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'resultindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'resultindex'));
		
	}
	
	public function admin_totlistdelete($id = null) {
		
		$this->Download->id = $id;
		if (!$this->Download->exists()) {
			throw new NotFoundException(__('Invalid Id'));
		}
		
		$downloadfile = $this->Download->find('first',array('conditions'=>array('Download.id'=>$id),'fields'=>array('Download.downloadfile')));
		if(!empty($downloadfile) && unlink($downloadfile['Download']['downloadfile'])){
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'totlistindex'));
			}
		}else{
			if ($this->Download->delete()) {
				$this->Session->setFlash(__('File deleted'));
				$this->redirect(array('action' => 'totlistindex'));
			}	
		}
		
		$this->Session->setFlash(__('File was not deleted'));
		$this->redirect(array('action' => 'totlistindex'));
		
	}
	
	
}