<?php
App::uses('AppController', 'Controller');
class ContactsController extends AppController {

   var $name = 'Contacts';  
   public $components = array('Paginator');
   
   public function beforeFilter(){	  
	   parent::beforeFilter();
	   $this->Auth->allow('contactinfo','savecontactinfo');
	}
   
   public function contactinfo()
    {
       $this->layout = 'inner';
	   $this->set("title_for_layout","Kanchkura University College");
	   
    }
  
  public function savecontactinfo($name, $email, $message)
    {
       $this->autoRender = false;
	   $data = array('Contact' => array('name'=>$name, 'email'=> $email, 'message'=> $message, 'isactive'=>1));   	   $this->Contact->save($data);
    }
  
  public function admin_index() {
        $this->Contact->recursive = 0;
		$contacts = $this->Paginator->paginate($this->Contact);
        $this->set('contacts', $contacts);
    }
	
  public function admin_delete($id = null) {
        if (!$id) {
            $this->Session->setFlash(__('Invalid id for Contact'));
            $this->redirect(array('action' => 'index'));
        }
        if ($this->Contact->delete($id)) {
            $this->Session->setFlash(__('Contact deleted'));
            $this->redirect(array('action' => 'index'));
        }
        $this->Session->setFlash(__('Contact was not deleted'));
        $this->redirect(array('action' => 'index'));
    }
   
}
?>