<?php
App::uses('AppController', 'Controller');
/**
 * Banners Controller
 *
 * @property Banner $Banner
 * @property PaginatorComponent $Paginator
 * @property FileUploadComponent $FileUpload
 */
class BannersController extends AppController {

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator', 'FileUpload');

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Banner->recursive = 0;
		$this->set('banners', $this->Paginator->paginate());
	}

/**
 * admin_add method
 *
 * @return void
 */
	public function admin_add(){
		
		if(!empty($this->request->data)){
			
			$createdby = $this->Auth->user('id');
			if($this->request->data['Banner']['bannerimage']['name'] != null){
					
				$target_path = WWW_ROOT."files".DS."banner";
				$target_path_for_database ="files"."/"."banner/";
				
				$filename = $this->request->data['Banner']['bannerimage']['name'];
				$tmpname  = $this->request->data['Banner']['bannerimage']['tmp_name'];
				$filesize = $this->request->data['Banner']['bannerimage']['size'];
				$filetype = $this->request->data['Banner']['bannerimage']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($filename) > 0){
					$this->request->data['Banner']['filename'] = $target_path_for_database.$filename;
				}else{
					$this->Session->setFlash("The file type is not valid.",true);
					$this->redirect(array('controller' => 'banners','action'=>'add'));
				}				
			}
						
			$this->request->data['Banner']['isctive'] = 1;
			$this->request->data['Banner']['createdby'] = $createdby;
			if($this->Banner->save($this->request->data['Banner'])){
				$this->redirect(array('controller' => 'banners','action'=>'index'));	
			}
		}
	}

/**
 * admin_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		
		if (!$this->Banner->exists($id)) {
			throw new NotFoundException(__('Invalid Banner'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			
			$modifiedby = $this->Auth->user('id');
			if($this->request->data['Banner']['bannerimage']['name'] != null){	
				$target_path = WWW_ROOT."files".DS."banner";
				$target_path_for_database ="files"."/"."banner/";
				
				$filename = $this->request->data['Banner']['bannerimage']['name'];
				$tmpname  = $this->request->data['Banner']['bannerimage']['tmp_name'];
				$filesize = $this->request->data['Banner']['bannerimage']['size'];
				$filetype = $this->request->data['Banner']['bannerimage']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($filename) > 0){
					if(!empty($this->request->data['Banner']['filename'])){
						if(unlink($this->request->data['Banner']['filename'])){
							$this->request->data['Banner']['filename'] = $target_path_for_database.$filename;
						}
					}else{
						$this->request->data['Banner']['filename'] = $target_path_for_database.$filename;
					}
				}				
			 }
			 
			$this->request->data['Banner']['modifiedby'] = $modifiedby;
			if($this->Banner->save($this->request->data['Banner'])){
				$this->redirect(array('controller' => 'banners','action'=>'index'));	
			}else{
				$this->Session->setFlash(__('The banner could not be edited. Please, try again.'));
				$this->redirect(array('action' => 'edit',$this->request->data['Banner']['id']));
			}
			
		}else {
			$options = array('conditions' => array('Banner.' . $this->Banner->primaryKey => $id));
			$this->request->data = $this->Banner->find('first', $options);
		}
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Banner->id = $id;
		if (!$this->Banner->exists()) {
			throw new NotFoundException(__('Invalid banner'));
		}
		$this->request->onlyAllow('post', 'delete');
		$filename = $this->Banner->find('first',array('conditions'=>array('Banner.id'=>$id),'fields'=>array('Banner.filename')));
		if(!empty($filename['Banner']['filename'])){
			if(unlink($filename['Banner']['filename'])){
				if ($this->Banner->delete()) {
					$this->Session->setFlash(__('Banner deleted', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Banner->delete()) {
					$this->Session->setFlash(__('Banner deleted', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->Banner->delete()) {
				$this->Session->setFlash(__('Banner deleted', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		
		$this->Session->setFlash(__('The banner could not be deleted. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
		$this->redirect(array('action' => 'index'));
	}
	
}